// LCD driver st7789
// 240*480

#include "KanjiDisplay_ST7789.h"

#define LCD_SCK   10
#define LCD_MOSI  11
#define LCD_MISO  12
#define LCD_CS    13
#define LCD_DC    14
#define LCD_RST   15
#define LCD_BL    16

#define LCD_WIDTH  240
#define LCD_HEIGHT 320


//Adafruit_ST7789 tft = Adafruit_ST7789(LCD_CS, LCD_DC, LCD_MOSI,LCD_SCK,LCD_RST);
cKanjiDisplay_ST7789 tft = cKanjiDisplay_ST7789(LCD_CS, LCD_DC, LCD_MOSI,LCD_SCK,LCD_RST);

#ifdef LED_BUILTIN
  #undef LED_BUILTIN
#endif

#define LED_BUILTIN LCD_BL // LCD back light

void setup(void) {
  //
  pinMode(LED_BUILTIN, OUTPUT);
  //
  tft.init(LCD_WIDTH, LCD_HEIGHT);           // Init ST7789 320x240
  tft.setRotation(3);   // sw-position 0:left  1:down  2:right  3:up
  tft.fillScreen(ST77XX_RED);
  tft.drawRect(95, 135, 50, 50, ST77XX_GREEN);
  tft.drawRect(10, 10, 10, 10, ST77XX_GREEN);
  tft.drawRect(200, 10, 10, 10, ST77XX_YELLOW);

  tft.SelectFont( cKanjiDisplay::FontKind::Shinonome12_1) ;
  tft.DrawString(0,32,"温度 25.4 ℃", ST77XX_BLUE);
}

float Humidity = 12.5 ;

// the loop function runs over and over again forever
void loop() {

  tft.fillRect(0,48,12*6,12,ST77XX_RED);
  tft.setTextColor(ST77XX_WHITE);
  tft.setCursor(0,48);
  tft.printf("湿度 %4.1f ％",Humidity);
  Humidity += 1.2 ;
 
  digitalWrite(LED_BUILTIN, HIGH);  // turn the LED on (HIGH is the voltage level)
  delay(1500);                      // wait for a second
  digitalWrite(LED_BUILTIN, LOW);   // turn the LED off by making the voltage LOW
  delay( 500);                      // wait for a second
}
