#include <arduino.h>
#include "KanjiDisplay_SSD1306.h"

#define SCREEN_WIDTH 128 // OLED display width, in pixels
#define SCREEN_HEIGHT 64 // OLED display height, in pixels
#define SCREEN_ADDRESS 0x3C ///< See datasheet for Address; 0x3D for 128x64, 0x3C for 128x32

cKanjiDisplay_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire);

float Humidity = 12.5 ;
void setup() {
  Serial.begin(115200);
  
  Wire.setClock( 50000 ) ;  // no need
  Wire.begin();

  // SSD1306_SWITCHCAPVCC = generate display voltage from 3.3V internally
  display.begin(SSD1306_SWITCHCAPVCC, SCREEN_ADDRESS);

  display.clearDisplay(); // Clear display buffer
  display.display();
  //display.setup();

  delay(500); 
}

void loop() {
  Serial.printf("---------- loop ---------\n");

  display.clearDisplay(); // Clear display buffer

  display.SelectFont( cKanjiDisplay::FontKind::Shinonome12_1) ;
  display.DrawString(0,0,"温度 25.4 ℃",1);

  display.SelectFont( cKanjiDisplay::FontKind::Shinonome12_1) ;
  display.setTextColor(1);
  display.setCursor(0,16);
  display.printf("湿度 %4.1f ％",Humidity);
  Humidity += 1.2 ;
  display.display();

  delay(1000);  

  display.clearDisplay(); // Clear display buffer
  display.display();

  delay(1000);  


}
