
#include <arduino.h>
#include <Kanji/KanjiHelper.h>

// 使用するFontを uncomment して下さい
// 必要なFontは https://github.com/HisayukiNomura/KNJGfx9341 に公開されている lib-9341 のKanji/Fonts に公開されています
// このライブラリーには sinonome12のlevel1 のみ同梱させて頂きました
// 他にも色々なFontが公開されています

//#define USE_SHINONOME12_ALL
#define USE_SHINONOME12_LEVEL1
//#define USE_SHINONOME12_SCHOOL

//#define USE_SHINONOME14_ALL
//#define USE_SHINONOME14_LEVEL1
//#define USE_SHINONOME14_SCHOOL

class cKanjiDisplay
{
public:
	

    enum class FontKind {
        Default,      // 
#ifdef USE_SHINONOME12_ALL
        Shinonome12_A,  // all
#endif
#ifdef USE_SHINONOME12_LEVEL1
        Shinonome12_1,  // level1
#endif
#ifdef USE_SHINONOME12_SCHOOL
        Shinonome12_S,  // scool
#endif
#ifdef USE_SHINONOME14_ALL
        Shinonome14_A,  // all
#endif
#ifdef USE_SHINONOME14_LEVEL1
        Shinonome14_1,  // level1
#endif
#ifdef USE_SHINONOME14_SCHOOL
        Shinonome14_S,  // scool
#endif
    };

private:
  // KnjiHelperの実態
  KanjiHelper KanjiFont;
  // 選択したFont
  FontKind SelectedFontKind = FontKind::Default ;
  // cKanjiDisplayから Adafruit_GFX を継承した表示器にBitmapを実際に描くための関数
  virtual void vDrawBitmap(int16_t x, int16_t y, const uint8_t bitmap[], int16_t w,int16_t h, uint16_t color)=0;
  // UTF8文字列からUTF8Codeをdecordする unicodeでは無い 漢字は下位3byteを使い英数は下位1byteを使う
  // 戻り値は消費したbyte数
  // DrawStringで使う
  int StrToUtf8Code(const char* pUTF8, uint32_t * Utf8Code);	
  //
  int UTF8RemainByteCount=0;  // use for KanjiWrite
  uint32_t  UTF8Code;         // use for KanjiWrite
  // Utf8CodeのFontをgetしてvDrawBitmapを使って描画する
  const KanjiData * DrawUTF8( int x, int y, uint32_t Utf8Code, uint16_t color );
protected:
  // Adafruit_GFXのprint系関数用
  const KanjiData * KanjiWrite( int x, int y, uint8_t c,  uint16_t color );

public:
	
  cKanjiDisplay() {};
  ~cKanjiDisplay() {};
  // 場所、色を直接指定して漢字文字列を描画する
  void DrawString( int x, int y, const char * str, uint16_t color);
  // 使用するFontの選択
  void SelectFont(FontKind aKType);
  // 選択したFontの種類を得る
  FontKind GetFontKind(){ return SelectedFontKind; };
};

